#include "videoqualitydlg.h"
#include "ui_videoqualitydlg.h"
#include "mainwindow.h"

VideoQualityDlg::VideoQualityDlg(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::VideoQualityDlg)
{
    ui->setupUi(this);

    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    ULONG BRIGHTNESS, CONSTRAST, HUE, SATURATION, SHARPNESS;

    this->setWindowTitle("VIDEO QUALITY");


    //BRIGHTNESS
    ui->Slider_BRIGHTNESS->setRange(0,255);

/*
    QCAP_GET_VIDEO_BRIGHTNESS( SC540dlg->m_hVideoDevice, &BRIGHTNESS );

    ui->Slider_BRIGHTNESS->setValue( (int)BRIGHTNESS );
*/

    //CONSTRAST
    ui->Slider_CONSTRAST->setRange(0,255);
/*
    QCAP_GET_VIDEO_CONTRAST( SC540dlg->m_hVideoDevice, &CONSTRAST);

    ui->Slider_CONSTRAST->setValue( (int)CONSTRAST );
*/
    //HUE
    ui->Slider_HUE->setRange(0,255);
/*
    QCAP_GET_VIDEO_HUE( SC540dlg->m_hVideoDevice, &HUE);

    ui->Slider_HUE->setValue( (int)HUE );
*/
    //SATURATION
    ui->Slider_SATURATION->setRange(0,255);
/*
    QCAP_GET_VIDEO_SATURATION( SC540dlg->m_hVideoDevice, &SATURATION);

    ui->Slider_SATURATION->setValue( (int)SATURATION );
*/
    //SHARPNESS
    ui->Slider_SHARPNESS->setRange(0,255);
/*
    QCAP_GET_VIDEO_SHARPNESS( SC540dlg->m_hVideoDevice, &SHARPNESS);

    ui->Slider_SHARPNESS->setValue( (int)SHARPNESS );
*/

}

VideoQualityDlg::~VideoQualityDlg()
{
    delete ui;
}

void VideoQualityDlg::on_pushButton_ok_clicked()
{
    this->close();
}

void VideoQualityDlg::on_pushButton_DEFAULT_clicked()
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();
/*
    if( SC540dlg->m_hVideoDevice != 0 )
    {
        QCAP_SET_VIDEO_BRIGHTNESS( SC540dlg->m_hVideoDevice, 128 );

        ui->Slider_BRIGHTNESS->setValue( 128 );

        QCAP_SET_VIDEO_CONTRAST( SC540dlg->m_hVideoDevice, 128 );

        ui->Slider_CONSTRAST->setValue( 128 );

        QCAP_SET_VIDEO_HUE( SC540dlg->m_hVideoDevice, 128 );

        ui->Slider_HUE->setValue( 128 );

        QCAP_SET_VIDEO_SATURATION( SC540dlg->m_hVideoDevice, 128 );

        ui->Slider_SATURATION->setValue( 128 );

        QCAP_SET_VIDEO_SHARPNESS( SC540dlg->m_hVideoDevice, 128 );

        ui->Slider_SHARPNESS->setValue( 128 );
    }
*/
}

void VideoQualityDlg::on_Slider_BRIGHTNESS_valueChanged(int value)
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    //QCAP_SET_VIDEO_BRIGHTNESS( SC540dlg->m_hVideoDevice, value );

    QString str_BRIGHTNESS;

    str_BRIGHTNESS.sprintf("%d",value);

    ui->label_BRIGHTNESS->setText(str_BRIGHTNESS);
 }

void VideoQualityDlg::on_Slider_CONSTRAST_valueChanged(int value)
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    //QCAP_SET_VIDEO_CONTRAST( SC540dlg->m_hVideoDevice, value );

    QString str_CONSTRAST;

    str_CONSTRAST.sprintf("%d",value);

    ui->label_CONSTRAST->setText(str_CONSTRAST);
}

void VideoQualityDlg::on_Slider_HUE_valueChanged(int value)
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    //QCAP_SET_VIDEO_HUE( SC540dlg->m_hVideoDevice, value );

    QString str_HUE;

    str_HUE.sprintf("%d",value);

    ui->label_HUE->setText(str_HUE);

}

void VideoQualityDlg::on_Slider_SATURATION_valueChanged(int value)
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    //QCAP_SET_VIDEO_SATURATION( SC540dlg->m_hVideoDevice, value );

    QString str_SATURATION;

    str_SATURATION.sprintf("%d",value);

    ui->label_SATURATION->setText(str_SATURATION);

}

void VideoQualityDlg::on_Slider_SHARPNESS_valueChanged(int value)
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    //QCAP_SET_VIDEO_SHARPNESS( SC540dlg->m_hVideoDevice, value );

    QString str_SHARPNESS;

    str_SHARPNESS.sprintf("%d",value);

    ui->label_SHARPNESS->setText(str_SHARPNESS);

}
